/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.util.HashSet;
import java.util.Vector;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfvalidator.ForeignContentListener;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class ForeignContentFilter
extends XMLFilterImpl {
    private static final String OFFICE_NAMESPACE_URI = OdfDocumentNamespace.OFFICE.getUri();
    private static final String TEXT_NAMESPACE_URI = OdfDocumentNamespace.TEXT.getUri();
    private static final String H = "h";
    private static final String P = "p";
    private static final String PROCESS_CONTENT = "process-content";
    private static final String TRUE = "true";
    private static HashSet<String> m_aODFNamespaceSet = null;
    private Vector<Boolean> m_aAlienElementProcessContents = null;
    private Vector<Boolean> m_aParagraphAncestorElements = null;
    private ForeignContentListener m_aForeignContentListener = null;
    private OdfVersion m_aVersion = null;
    private Logger m_aLogger;

    ForeignContentFilter(Logger aLogger, OdfVersion aVersion, ForeignContentListener aForeignContentListener) {
        this.m_aLogger = aLogger;
        this.m_aVersion = aVersion;
        this.m_aForeignContentListener = aForeignContentListener;
        this.m_aAlienElementProcessContents = new Vector();
        this.m_aParagraphAncestorElements = new Vector();
        m_aODFNamespaceSet = new HashSet();
        m_aODFNamespaceSet.add(OdfDocumentNamespace.OFFICE.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.STYLE.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.TEXT.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.TABLE.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.DRAW.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.FO.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.DC.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.META.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.NUMBER.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.SVG.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.CHART.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.DR3D.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.FORM.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.PRESENTATION.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.SMIL.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.CONFIG.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.SCRIPT.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.XLINK.getUri());
        m_aODFNamespaceSet.add(OdfDocumentNamespace.XFORMS.getUri());
        if (this.m_aVersion.compareTo(OdfVersion.V1_2) >= 0) {
            m_aODFNamespaceSet.add(OdfDocumentNamespace.XHTML.getUri());
            m_aODFNamespaceSet.add(OdfDocumentNamespace.GRDDL.getUri());
            m_aODFNamespaceSet.add(OdfDocumentNamespace.DB.getUri());
            m_aODFNamespaceSet.add("http://www.w3.org/XML/1998/namespace");
        }
    }

    @Override
    public void endElement(String aUri, String aLocalName, String aQName) throws SAXException {
        if (this.isAlienNamespace(aUri)) {
            this.m_aAlienElementProcessContents.removeElementAt(this.m_aAlienElementProcessContents.size() - 1);
        } else if (this.isProcessContent()) {
            this.m_aParagraphAncestorElements.removeElementAt(this.m_aParagraphAncestorElements.size() - 1);
            super.endElement(aUri, aLocalName, aQName);
        }
    }

    @Override
    public void startElement(String aUri, String aLocalName, String aQName, Attributes aAtts) throws SAXException {
        boolean bProcessContent = this.isProcessContent();
        if (this.isAlienNamespace(aUri)) {
            if (bProcessContent) {
                String aProcessContentValue = aAtts.getValue(OFFICE_NAMESPACE_URI, PROCESS_CONTENT);
                if (this.m_aVersion.compareTo(OdfVersion.V1_2) >= 0) {
                    bProcessContent = aProcessContentValue != null ? aProcessContentValue.equals(TRUE) : this.hasParagraphAncestorElement();
                } else {
                    boolean bl = bProcessContent = aProcessContentValue == null || aProcessContentValue.equals(TRUE);
                }
                if (this.m_aForeignContentListener != null) {
                    this.m_aForeignContentListener.foreignElementDetected(aUri, aLocalName, aQName, aAtts);
                }
                this.m_aLogger.logInfo(String.format("extension element <%s> found, element is ignored, element content is %s.", aQName, bProcessContent ? "processed" : "is ignored"), false);
            }
            this.m_aAlienElementProcessContents.addElement(bProcessContent);
        } else if (bProcessContent) {
            Attributes aOldAtts = aAtts;
            AttributesImpl aNewAtts = null;
            int i = aOldAtts.getLength();
            while (i > 0) {
                String aAttrUri;
                if (!this.isAlienNamespace(aAttrUri = aOldAtts.getURI(--i))) continue;
                if (aNewAtts == null) {
                    aNewAtts = new AttributesImpl(aOldAtts);
                    aAtts = aNewAtts;
                }
                if (this.m_aForeignContentListener != null) {
                    this.m_aForeignContentListener.foreignAttributeDetected(aAttrUri, aOldAtts.getLocalName(i), aOldAtts.getQName(i), aOldAtts.getValue(i));
                }
                this.m_aLogger.logInfo(String.format("extension attribute '%s' of element <%s> found and ignored.", aAtts.getQName(i), aQName), false);
                aNewAtts.removeAttribute(i);
            }
            boolean bParagraphAncestor = this.hasParagraphAncestorElement();
            this.m_aParagraphAncestorElements.add(bParagraphAncestor |= (aLocalName.equals(P) || aLocalName.equals(H)) && aUri.equals(TEXT_NAMESPACE_URI));
            super.startElement(aUri, aLocalName, aQName, aAtts);
        }
    }

    private boolean isAlienNamespace(String aUri) {
        return !m_aODFNamespaceSet.contains(aUri);
    }

    private boolean isProcessContent() {
        return this.m_aAlienElementProcessContents.isEmpty() ? true : this.m_aAlienElementProcessContents.lastElement();
    }

    private boolean hasParagraphAncestorElement() {
        return this.m_aParagraphAncestorElements.isEmpty() ? false : this.m_aParagraphAncestorElements.lastElement();
    }

    @Override
    public void characters(char[] aChars, int nStart, int nLength) throws SAXException {
        if (this.isProcessContent()) {
            super.characters(aChars, nStart, nLength);
        }
    }
}

