/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.MetaInformationListener;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

class MetaFilter
extends XMLFilterImpl {
    private boolean m_bInGenerator = false;
    private String m_aGenerator = "";
    private boolean m_bRoot = true;
    private static final String META_NAMESPACE_URI = OdfDocumentNamespace.META.getUri();
    private static final String OFFICE_NAMESPACE_URI = OdfDocumentNamespace.OFFICE.getUri();
    private static final String GENERATOR = "generator";
    private static final String DOCUMENT_META = "document-meta";
    private Logger m_aLogger;
    private MetaInformationListener m_aMetaListener;

    MetaFilter(Logger aLogger, MetaInformationListener aMetaListener) {
        this.m_aLogger = aLogger;
        this.m_aMetaListener = aMetaListener;
    }

    public void characters(char[] aChars, int nStart, int nLength) throws SAXException {
        super.characters(aChars, nStart, nLength);
        if (this.m_bInGenerator) {
            this.m_aGenerator = this.m_aGenerator + new String(aChars, nStart, nLength);
        }
    }

    public void endElement(String aUri, String aLocalName, String aQName) throws SAXException {
        super.endElement(aUri, aLocalName, aQName);
        if (aUri.equals(META_NAMESPACE_URI) && aLocalName.equals(GENERATOR)) {
            this.m_aGenerator = this.m_aGenerator.trim();
            this.m_aLogger.logInfo("Generator: " + this.m_aGenerator, false);
            this.m_bInGenerator = false;
            if (this.m_aMetaListener != null) {
                this.m_aMetaListener.setGenerator(this.m_aGenerator);
            }
        }
    }

    public void startElement(String aUri, String aLocalName, String aQName, Attributes aAttributes) throws SAXException {
        super.startElement(aUri, aLocalName, aQName, aAttributes);
        if (this.m_bRoot) {
            if (!aUri.equals(OFFICE_NAMESPACE_URI) || !aLocalName.equals(DOCUMENT_META)) {
                this.m_aLogger.logError("Invalid root element: " + aQName);
            }
            this.m_bRoot = false;
        }
        if (aUri.equals(META_NAMESPACE_URI) && aLocalName.equals(GENERATOR)) {
            this.m_bInGenerator = true;
        }
    }
}

