/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.fo.FoColumnCountAttribute;
import org.odftoolkit.odfdom.dom.attribute.fo.FoColumnGapAttribute;
import org.odftoolkit.odfdom.dom.element.style.StyleColumnElement;
import org.odftoolkit.odfdom.dom.element.style.StyleColumnSepElement;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

public class StyleColumnsElement
extends OdfElement {
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.STYLE, "columns");

    public StyleColumnsElement(OdfFileDom ownerDoc) {
        super(ownerDoc, ELEMENT_NAME);
    }

    public OdfName getOdfName() {
        return ELEMENT_NAME;
    }

    public Integer getFoColumnCountAttribute() {
        FoColumnCountAttribute attr = (FoColumnCountAttribute)this.getOdfAttribute(OdfDocumentNamespace.FO, "column-count");
        if (attr != null) {
            return attr.intValue();
        }
        return null;
    }

    public void setFoColumnCountAttribute(Integer foColumnCountValue) {
        FoColumnCountAttribute attr = new FoColumnCountAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setIntValue(foColumnCountValue);
    }

    public String getFoColumnGapAttribute() {
        FoColumnGapAttribute attr = (FoColumnGapAttribute)this.getOdfAttribute(OdfDocumentNamespace.FO, "column-gap");
        if (attr != null) {
            return String.valueOf(attr.getValue());
        }
        return null;
    }

    public void setFoColumnGapAttribute(String foColumnGapValue) {
        FoColumnGapAttribute attr = new FoColumnGapAttribute((OdfFileDom)this.ownerDocument);
        this.setOdfAttribute(attr);
        attr.setValue(foColumnGapValue);
    }

    public StyleColumnElement newStyleColumnElement(String styleRelWidthValue) {
        StyleColumnElement styleColumn = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleColumnElement.class);
        styleColumn.setStyleRelWidthAttribute(styleRelWidthValue);
        this.appendChild(styleColumn);
        return styleColumn;
    }

    public StyleColumnSepElement newStyleColumnSepElement(String styleWidthValue) {
        StyleColumnSepElement styleColumnSep = ((OdfFileDom)this.ownerDocument).newOdfElement(StyleColumnSepElement.class);
        styleColumnSep.setStyleWidthAttribute(styleWidthValue);
        this.appendChild(styleColumnSep);
        return styleColumnSep;
    }

    public void accept(ElementVisitor visitor) {
        if (visitor instanceof DefaultElementVisitor) {
            DefaultElementVisitor defaultVisitor = (DefaultElementVisitor)visitor;
            defaultVisitor.visit(this);
        } else {
            visitor.visit(this);
        }
    }
}

