/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.FontFactoryImp;
import com.lowagie.text.ListItem;
import com.lowagie.text.Paragraph;
import com.lowagie.text.html.simpleparser.ChainedProperties;
import com.lowagie.text.markup.MarkupParser;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class FactoryProperties {
    private FontFactoryImp fontImp = FontFactory.getFontImp();
    public static HashMap followTags = new HashMap();

    public Chunk createChunk(String text, ChainedProperties props) {
        Chunk ck = new Chunk(text, this.getFont(props));
        if (props.hasProperty("sub")) {
            ck.setTextRise(-6.0f);
        } else if (props.hasProperty("sup")) {
            ck.setTextRise(6.0f);
        }
        return ck;
    }

    private static void setParagraphLeading(Paragraph p, String leading) {
        if (leading == null) {
            p.setLeading(0.0f, 1.5f);
            return;
        }
        try {
            StringTokenizer tk = new StringTokenizer(leading, " ,");
            String v = tk.nextToken();
            float v1 = Float.parseFloat(v);
            if (!tk.hasMoreTokens()) {
                p.setLeading(v1, 0.0f);
                return;
            }
            v = tk.nextToken();
            float v2 = Float.parseFloat(v);
            p.setLeading(v1, v2);
        }
        catch (Exception e) {
            p.setLeading(0.0f, 1.5f);
        }
    }

    public static Paragraph createParagraph(HashMap props) {
        Paragraph p = new Paragraph();
        String value = (String)props.get("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(p, (String)props.get("leading"));
        return p;
    }

    public static void createParagraph(Paragraph p, ChainedProperties props) {
        String value = props.getProperty("align");
        if (value != null) {
            if (value.equalsIgnoreCase("center")) {
                p.setAlignment(1);
            } else if (value.equalsIgnoreCase("right")) {
                p.setAlignment(2);
            } else if (value.equalsIgnoreCase("justify")) {
                p.setAlignment(3);
            }
        }
        FactoryProperties.setParagraphLeading(p, props.getProperty("leading"));
        value = props.getProperty("before");
        if (value != null) {
            try {
                p.setSpacingBefore(Float.parseFloat(value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value = props.getProperty("after")) != null) {
            try {
                p.setSpacingAfter(Float.parseFloat(value));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((value = props.getProperty("extraparaspace")) != null) {
            try {
                p.setExtraParagraphSpace(Float.parseFloat(value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Paragraph createParagraph(ChainedProperties props) {
        Paragraph p = new Paragraph();
        FactoryProperties.createParagraph(p, props);
        return p;
    }

    public static ListItem createListItem(ChainedProperties props) {
        ListItem p = new ListItem();
        FactoryProperties.createParagraph(p, props);
        return p;
    }

    public Font getFont(ChainedProperties props) {
        String face = props.getProperty("face");
        if (face != null) {
            StringTokenizer tok = new StringTokenizer(face, ",");
            while (tok.hasMoreTokens()) {
                face = tok.nextToken().trim();
                if (face.startsWith("\"")) {
                    face = face.substring(1);
                }
                if (face.endsWith("\"")) {
                    face = face.substring(0, face.length() - 1);
                }
                if (!this.fontImp.isRegistered(face)) continue;
            }
        }
        int style = 0;
        if (props.hasProperty("i")) {
            style |= 2;
        }
        if (props.hasProperty("b")) {
            style |= 1;
        }
        if (props.hasProperty("u")) {
            style |= 4;
        }
        String value = props.getProperty("size");
        float size = 12.0f;
        if (value != null) {
            size = Float.parseFloat(value);
        }
        Color color = MarkupParser.decodeColor(props.getProperty("color"));
        String encoding = props.getProperty("encoding");
        if (encoding == null) {
            encoding = "Cp1252";
        }
        return this.fontImp.getFont(face, encoding, true, size, style, color);
    }

    public static void insertStyle(HashMap h) {
        String style = (String)h.get("style");
        if (style == null) {
            return;
        }
        Properties prop = MarkupParser.parseAttributes(style);
        Iterator<Object> it = prop.keySet().iterator();
        while (it.hasNext()) {
            String ss;
            String key = (String)it.next();
            if (key.equals("font-family")) {
                h.put("face", prop.getProperty(key));
                continue;
            }
            if (key.equals("font-size")) {
                h.put("size", Float.toString(MarkupParser.parseLength(prop.getProperty(key))) + "px");
                continue;
            }
            if (key.equals("font-style")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("italic") && !ss.equals("oblique")) continue;
                h.put("i", null);
                continue;
            }
            if (key.equals("font-weight")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("bold") && !ss.equals("700") && !ss.equals("800") && !ss.equals("900")) continue;
                h.put("b", null);
                continue;
            }
            if (key.equals("font-weight")) {
                ss = prop.getProperty(key).trim().toLowerCase();
                if (!ss.equals("underline")) continue;
                h.put("u", null);
                continue;
            }
            if (key.equals("color")) {
                Color c = MarkupParser.decodeColor(prop.getProperty(key));
                if (c == null) continue;
                int hh = c.getRGB();
                String hs = Integer.toHexString(hh);
                hs = "000000" + hs;
                hs = "#" + hs.substring(hs.length() - 6);
                h.put("color", hs);
                continue;
            }
            if (key.equals("line-height")) {
                ss = prop.getProperty(key).trim();
                float v = MarkupParser.parseLength(prop.getProperty(key));
                if (ss.endsWith("%")) {
                    h.put("leading", "0," + v / 100.0f);
                    continue;
                }
                h.put("leading", v + ",0");
                continue;
            }
            if (!key.equals("text-align")) continue;
            ss = prop.getProperty(key).trim().toLowerCase();
            h.put("align", ss);
        }
    }

    public FontFactoryImp getFontImp() {
        return this.fontImp;
    }

    public void setFontImp(FontFactoryImp fontImp) {
        this.fontImp = fontImp;
    }

    static {
        followTags.put("i", "i");
        followTags.put("b", "b");
        followTags.put("u", "u");
        followTags.put("sub", "sub");
        followTags.put("sup", "sup");
        followTags.put("em", "i");
        followTags.put("strong", "b");
    }
}

