/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.zip.ZipException;
import javax.xml.validation.Validator;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.ManifestEntry;
import org.odftoolkit.odfvalidator.ManifestEntryListener;
import org.odftoolkit.odfvalidator.ManifestFilter;
import org.odftoolkit.odfvalidator.ODFPackageErrorHandler;
import org.odftoolkit.odfvalidator.ODFPackageValidator;
import org.odftoolkit.odfvalidator.ODFSubPackageValidator;
import org.odftoolkit.odfvalidator.ODFValidatorException;
import org.odftoolkit.odfvalidator.ODFValidatorProvider;
import org.odftoolkit.odfvalidator.OdfValidatorMode;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.odftoolkit.odfvalidator.SAXParseExceptionFilter;
import org.xml.sax.ErrorHandler;

abstract class ODFRootPackageValidator
extends ODFPackageValidator
implements ManifestEntryListener {
    private OdfPackage m_aPkg = null;
    private ArrayList<ManifestEntry> m_aSubDocs = null;
    private ODFPackageErrorHandler m_ErrorHandler = null;

    protected ODFRootPackageValidator(Logger.LogLevel nLogLevel, OdfValidatorMode eMode, OdfVersion aVersion, SAXParseExceptionFilter aFilter, ODFValidatorProvider aValidatorProvider) {
        super(nLogLevel, eMode, aVersion, aFilter, aValidatorProvider);
    }

    protected abstract OdfPackage getPackage(ErrorHandler var1) throws Exception;

    protected OdfPackage getPackage(Logger aLogger) {
        if (this.m_aPkg == null) {
            try {
                this.m_ErrorHandler = new ODFPackageErrorHandler();
                this.m_aPkg = this.getPackage(this.m_ErrorHandler);
                try {
                    OdfDocument.loadDocument(this.m_aPkg, "");
                }
                catch (Exception e) {}
            }
            catch (IOException e) {
                if (e.getMessage().startsWith("only DEFLATED entries can have EXT descriptor")) {
                    aLogger.logFatalError("The document is encrypted. Validation of encrypted documents is not supported.");
                } else {
                    aLogger.logFatalError(e.getMessage());
                }
            }
            catch (Exception e) {
                StringWriter errors = new StringWriter();
                e.printStackTrace(new PrintWriter(errors));
                aLogger.logFatalError(e.getMessage() + "\n" + errors.toString());
            }
        }
        return this.m_aPkg;
    }

    protected String getStreamName(String aEntry) {
        return aEntry;
    }

    protected boolean validatePre(Logger aLogger, OdfVersion aVersion) throws ODFValidatorException, IOException {
        Logger aManifestLogger = new Logger(OdfPackage.OdfFile.MANIFEST.getPath(), aLogger);
        Logger aMimetypeLogger = new Logger("mimetype", aLogger);
        this.m_aPkg.getFilePaths();
        boolean bErrorsFound = this.m_ErrorHandler.processErrors(aLogger, aManifestLogger, aMimetypeLogger, aVersion);
        bErrorsFound |= this.validateMimetype(aMimetypeLogger, aVersion);
        aMimetypeLogger.logSummaryInfo();
        return bErrorsFound |= this.validateManifest(aManifestLogger, aVersion);
    }

    protected boolean validatePost(Logger aLogger, OdfVersion aVersion) throws ODFValidatorException, IOException {
        boolean bHasErrors = false;
        if (this.m_aSubDocs != null) {
            for (ManifestEntry aEntry : this.m_aSubDocs) {
                ODFSubPackageValidator aPackageValidator = new ODFSubPackageValidator(this.getPackage(aLogger), this.getLoggerName(), aEntry.getFullPath(), aEntry.getMediaType(), this.m_nLogLevel, this.m_eMode, this.m_aConfigVersion, this.m_aFilter, this.m_aResult.getGenerator(), this.m_aValidatorProvider);
                bHasErrors |= aPackageValidator.validate(aLogger);
            }
        }
        if (aVersion.compareTo(OdfVersion.V1_2) >= 0) {
            bHasErrors |= this.validateDSig(aLogger, "META-INF/documentsignatures.xml", aVersion);
            bHasErrors |= this.validateDSig(aLogger, "META-INF/macrosignatures.xml", aVersion);
        }
        return bHasErrors;
    }

    protected void logSummary(boolean bHasErrors, Logger aLogger) {
        aLogger.logSummaryInfo();
        if ((bHasErrors || aLogger.hasError()) && this.m_nLogLevel.compareTo(Logger.LogLevel.INFO) < 0) {
            aLogger.logInfo("Generator: " + this.m_aResult.getGenerator(), true);
        }
    }

    public void foundManifestEntry(ManifestEntry aManifestEntry) {
        if (aManifestEntry.isOpenDocumentMediaType()) {
            if (this.m_aSubDocs == null) {
                this.m_aSubDocs = new ArrayList();
            }
            this.m_aSubDocs.add(aManifestEntry);
        }
    }

    private boolean validateMimetype(Logger aLogger, OdfVersion aVersion) {
        boolean bHasErrors = false;
        String aMimetype = this.getPackage(aLogger).getMediaTypeString();
        if (aMimetype == null || aMimetype.length() == 0) {
            aLogger.logFatalError("file is not a zip file, or has no mimetype.");
            bHasErrors = true;
        } else if (!(aMimetype.equals("application/vnd.oasis.opendocument.text") || aMimetype.equals("application/vnd.oasis.opendocument.text-template") || aMimetype.equals("application/vnd.oasis.opendocument.graphics") || aMimetype.equals("application/vnd.oasis.opendocument.graphics-template") || aMimetype.equals("application/vnd.oasis.opendocument.presentation") || aMimetype.equals("application/vnd.oasis.opendocument.spreadsheet") || aMimetype.equals("application/vnd.oasis.opendocument.spreadsheet-template") || aMimetype.equals("application/vnd.oasis.opendocument.chart") || aMimetype.equals("application/vnd.oasis.opendocument.chart-template") || aMimetype.equals("application/vnd.oasis.opendocument.image") || aMimetype.equals("application/vnd.oasis.opendocument.image-template") || aMimetype.equals("application/vnd.oasis.opendocument.formula") || aMimetype.equals("application/vnd.oasis.opendocument.formula-template") || aMimetype.equals("application/vnd.oasis.opendocument.text-master") || aMimetype.equals("application/vnd.oasis.opendocument.text-web"))) {
            aLogger.logInfo("mimetype is not an ODFMediaTypes mimetype.", false);
            bHasErrors = true;
        }
        return bHasErrors;
    }

    private boolean validateManifest(Logger aLogger, OdfVersion aVersion) throws IOException, ZipException, IllegalStateException, ODFValidatorException {
        boolean bRet;
        ManifestFilter aFilter = new ManifestFilter(aLogger, this.m_aResult, this);
        Validator aManifestValidator = this.m_aValidatorProvider.getManifestValidator(aLogger.getOutputStream(), aVersion);
        if (aManifestValidator != null) {
            bRet = this.validateEntry(aFilter, aManifestValidator, aLogger, OdfPackage.OdfFile.MANIFEST.getPath());
        } else {
            aLogger.logInfo("Validation of " + OdfPackage.OdfFile.MANIFEST.getPath() + " skipped.", false);
            bRet = this.parseEntry(aFilter, aLogger, OdfPackage.OdfFile.MANIFEST.getPath(), false);
        }
        return bRet;
    }
}

